<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Life In Nature - Official Game Guide</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            color: #333;
            margin: 0;
            padding: 0;
            line-height: 1.6;
        }
        .container {
            width: 80%;
            margin: auto;
            overflow: hidden;
            padding: 20px 0;
        }
        header {
            background: #505050;
            color: #fff;
            padding-top: 20px;
            min-height: 70px;
            border-bottom: #77aaff 3px solid;
            text-align: center;
        }
        header a {
            color: #fff;
            text-decoration: none;
            text-transform: uppercase;
            font-size: 16px;
        }
        header h1 {
            margin: 0;
            font-size: 24px;
        }
        .logo-section {
            text-align: center;
            padding: 20px 0;
        }
        .logo-section img {
            max-width: 150px;
            height: auto;
        }
        h2, h3 {
            color: #4a4a4a;
            border-bottom: 2px solid #ccc;
            padding-bottom: 5px;
            margin-top: 30px;
        }
        .main-heading {
            font-size: 36px;
            text-align: center;
            color: #2c3e50;
            margin-bottom: 20px;
        }
        ul {
            list-style: none;
            padding: 0;
        }
        ul li {
            background: #e6e6ea;
            margin-bottom: 10px;
            padding: 15px;
            border-left: 5px solid #77aaff;
            border-radius: 5px;
        }
        ul li a {
            color: #333;
            text-decoration: none;
            font-weight: bold;
            display: block;
            font-size: 1.1em;
        }
        .credits-list p {
            margin: 5px 0;
        }
        .credits-list strong {
            color: #2c3e50;
        }
        footer {
            padding: 20px;
            margin-top: 40px;
            color: #fff;
            background-color: #505050;
            text-align: center;
        }
    </style>
</head>
<body>

    <header>
        <h1><a href="https://audiowander.com">AudioWander</a></h1>
    </header>

    <div class="container">

        <section class="logo-section">
            <img src="../placeholder-logo.png" alt="AudioWander Team Logo">
        </section>

        <h1 class="main-heading">Life In Nature Official Game Guide</h1>

        <h2>Welcome to the Game Guide</h2>
        <p>
            Welcome to the official Life in Nature Game Guide. This guide will be updated regularly in response to new game features, bug fixes, and general updates. Use the links below to navigate through essential game information.
        </p>

        <h2>Important Guide Pages</h2>
        <p>
            To learn how to play the game and survive, please follow these instructional pages:
        </p>
        <ul>
            <li><a href="#getting-started">Getting Started with the Game: getting_started.html</a></li>
            <li><a href="#account">Account Management: account_management.html</a></li>
            <li><a href="#controls-keyboard">Keyboard Controls: controls_keyboard.html</a></li>
            <li><a href="#controls-commands">In-Game Commands: controls_commands.html</a></li>
            <li><a href="#map">Game Maps Guide: Game_map_guide.html</a></li>
            <li><a href="#crafting">Crafting System & Recipes: system_crafting.html</a></li>
            <li><a href="#gathering">Gathering Resources & Cooking: system_gathering_cooking.html</a></li>
            <li><a href="#survival">Survival Systems: system_survival.html</a></li>
            <li><a href="#combat">Combat & PK Mode: system_combat.html</a></li>
            <li><a href="#quests">Guide to Quests and Missions: quests guide.html</a></li>
        </ul>

        <h2 id="credits">Credits</h2>
        <p>
            Thank you to everyone who contributed to the creation and maintenance of this guide.
        </p>
        <div class="credits-list">
            <p><strong>Contributor:</strong> Ali Jafari</p>
            <p><strong>Contributor:</strong> Seyyed Abbass Hosseini</p>
            <p>Prepared by the AudioWander Team.</p>
        </div>

    </div>

    <footer>
        <p>Copyright &copy; <?php echo date("Y"); ?> AudioWander Team.</p>
    </footer>

</body>
</html>